@extends('layout')
@section('content')

@include('partials.breadcrumb')
    <!-- dedicated plan begin-->
    <div class="dedicated-plan">
        <div class="container">


            <div class="row">
                <div class="col-xl-12 col-lg-12">
                    <div class="plan-table">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">@lang('USERNAME') </th>
                                <th scope="col">@lang('SENT') </th>
                                <th scope="col">@lang('RECEIVE') </th>
                                <th scope="col">@lang('AMOUNT') </th>
                                <th scope="col">@lang('STATUS') </th>
                            </tr>
                            </thead>
                            <tbody>

                            @foreach ($completedExchanges as $order)
                                <tr>
                                    <th scope="row">{{ $order->user->username }}</th>
                                    <td>{{ $order->send_method->name }}</td>
                                    <td>{{ $order->receive_method->name }}</td>
                                    <td>{{ $order->send_amount }}  <i class="fas fa-exchange-alt"></i>  {{ $order->receive_amount }}</td>
                                    <td><i class="fa fa-spinner"></i> @lang('Processing') </td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>

                        {{$completedExchanges->links()}}
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- dedicated plan end -->


@stop


@section('script')
@stop
@section('js')
@stop